/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.simulation;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioMenuHelper;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioMenuItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;

class VWScenarioCollectionMenu
extends JMenu
implements ActionListener {
    private VWScenarioMenuHelper m_scenarioMenuHelper = null;

    public VWScenarioCollectionMenu(VWScenarioMenuHelper scenarioMenuHelper) {
        super(VWResource.s_menuScenarios_withHK);
        this.m_scenarioMenuHelper = scenarioMenuHelper;
        this.reinitialize();
    }

    public void setText(String text) {
        JMenu tempMenu = VWStringUtils.getMenuUsingString(text);
        if (tempMenu != null) {
            super.setText(tempMenu.getText());
            this.setMnemonic(tempMenu.getMnemonic());
        } else {
            super.setText(text);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() instanceof VWScenarioMenuItem) {
                VWScenarioMenuItem menuItem = (VWScenarioMenuItem)event.getSource();
                this.m_scenarioMenuHelper.displayScenarioProperties(menuItem.getPropertyData());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            this.removeAll();
            VWSIMPropertyData[] dataItems = this.m_scenarioMenuHelper.getScenarioDataItems();
            if (dataItems != null) {
                for (int nIndex = 0; nIndex < dataItems.length; ++nIndex) {
                    VWScenarioMenuItem menuItem = new VWScenarioMenuItem(dataItems[nIndex]);
                    menuItem.addActionListener(this);
                    this.add(menuItem);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWScenarioMenuItem findScenarioMenuItem(String scenarioName) {
        try {
            Component[] components = this.getMenuComponents();
            for (int nIndex = 0; nIndex < components.length; ++nIndex) {
                VWScenarioMenuItem scenarioMenuItem;
                VWScenarioDefinition tmpScenarioDef;
                if (components[nIndex] == null || !(components[nIndex] instanceof VWScenarioMenuItem) || VWStringUtils.compare(scenarioName, (tmpScenarioDef = (scenarioMenuItem = (VWScenarioMenuItem)components[nIndex]).getPropertyData().getScenarioDefinition()).getName()) != 0) continue;
                return scenarioMenuItem;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

